#!/bin/bash
#PBS -l nodes=1:ppn=8
##PBS -l mem=100gb
#PBS -l walltime=24:00:00
#PBS -d ./
#PBS -j oe

start=`date +%s`

CPU=$PBS_NP
if [ ! $CPU ]; then
   CPU=2
fi

N=$PBS_ARRAYID
if [ ! $N ]; then
    N=1
fi

#----------------
ctg=`ls *_match_genome.fa | head -n $N | tail -n 1`
prefix=${ctg%_match_genome.fa}
genome='/public1/home/miyj/sars/data_sports/Homo_sapiens/genome/hg38/genome.fa'
gff='/public1/home/miyj/sars/fig2/2B/hsa.gff3'
program='/public1/home/miyj/sars/fig1/1C/dict-fa-total.py'
echo "CPU= $CPU"
echo "FILE= $ctg"
echo "FILE_PREFIX= $prefix"

#if [ ! -e ${prefix} ]; then
   echo "featurecounts prepare"
   source activate
   conda deactivate   
   conda activate smallRNA
   bowtie-build $genome genome
   echo "bowtie build finished"
   python $program $ctg ${prefix}.fa
   bowtie -f -v 1 -k 10 -S -t -p $CPU genome ${prefix}.fa ${prefix}.sam
   echo "bowtie finished"
   bioawk -c sam -H '!and($flag,4)' ${prefix}.sam > ${prefix}-new.sam
   rm ${prefix}.sam
   echo "sam filter finished"
   featureCounts -t miRNA -g Name -s 1 -a $gff -o ${prefix}-new.txt ${prefix}-new.sam
   echo "featureCounts finished"
   rm ${prefix}-new.sam
#fi

#----------------
end=`date +%s`
runtime=$((end-start))
h=$(($runtime/3600))
hh=$(($runtime%3600))
m=$(($hh/60))
s=$(($hh%60))

echo "Start= $start"
echo "End= $end"
echo "Run time= $h:$m:$s"
echo "Done!"

